

<div class="container mt-5">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h3 class="text-center">Adult French Learner Registration</h3>
                </div>
                <div class="card-body">
                    <?php if($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger">
                            <?= $this->session->flashdata('error') ?>
                        </div>
                    <?php endif; ?>

                    <?php if($this->session->flashdata('success')): ?>
                        <div class="alert alert-success">
                            <?= $this->session->flashdata('success') ?>
                        </div>
                    <?php endif; ?>

                    <?= form_open('adult_registration/submit', ['class' => 'needs-validation', 'novalidate' => 'novalidate']) ?>
					<!-- Add this hidden input for CSRF -->
                    <?php echo form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>
    
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">First Name <span class="text-danger">*</span></label>
                                <input type="text" name="first_name" class="form-control" 
                                       value="<?= set_value('first_name') ?>" required>
                                <?= form_error('first_name', '<small class="text-danger">', '</small>') ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Surname <span class="text-danger">*</span></label>
                                <input type="text" name="surname" class="form-control" 
                                       value="<?= set_value('surname') ?>" required>
                                <?= form_error('surname', '<small class="text-danger">', '</small>') ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Age <span class="text-danger">*</span></label>
                                <input type="number" name="age" class="form-control" 
                                       value="<?= set_value('age') ?>" min="18" max="120" required>
                                <?= form_error('age', '<small class="text-danger">', '</small>') ?>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Gender <span class="text-danger">*</span></label>
                                <select name="gender" class="form-control" required>
                                    <option value="">Select Gender</option>
                                    <option value="Male" <?= set_select('gender', 'Male') ?>>Male</option>
                                    <option value="Female" <?= set_select('gender', 'Female') ?>>Female</option>
                                    <option value="Other" <?= set_select('gender', 'Other') ?>>Other</option>
                                </select>
                                <?= form_error('gender', '<small class="text-danger">', '</small>') ?>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">French Level <span class="text-danger">*</span></label>
                                <select name="french_level" class="form-control" required>
                                    <option value="">Select Level</option>
                                    <option value="Beginner" <?= set_select('french_level', 'Beginner') ?>>Beginner</option>
                                    <option value="BeginnerPlus" <?= set_select('french_level', 'BeginnerPlus') ?>>Beginner Plus</option>
                                    <option value="Intermediate" <?= set_select('french_level', 'Intermediate') ?>>Intermediate</option>
                                    <option value="Almost advanced" <?= set_select('french_level', 'Almost advanced') ?>>Almost Advanced</option>
                                </select>
                                <?= form_error('french_level', '<small class="text-danger">', '</small>') ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Email Address <span class="text-danger">*</span></label>
                                <input type="email" name="email" class="form-control" 
                                       value="<?= set_value('email') ?>" required>
                                <?= form_error('email', '<small class="text-danger">', '</small>') ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Contact Number <span class="text-danger">*</span></label>
                                <input type="tel" name="contact_number" class="form-control" 
                                       value="<?= set_value('contact_number') ?>" required>
                                <?= form_error('contact_number', '<small class="text-danger">', '</small>') ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Home Location <span class="text-danger">*</span></label>
                                <input type="text" name="home_location" class="form-control" 
                                       value="<?= set_value('home_location') ?>" required>
                                <?= form_error('home_location', '<small class="text-danger">', '</small>') ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Field of Work</label>
                                <input type="text" name="field_of_work" class="form-control" 
                                       value="<?= set_value('field_of_work') ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Favorite French Activity</label>
                                <input type="text" name="favorite_french_activity" class="form-control" 
                                       value="<?= set_value('favorite_french_activity') ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Area of Improvement</label>
                                <input type="text" name="area_of_improvement" class="form-control" 
                                       value="<?= set_value('area_of_improvement') ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Preferred Lesson Times</label>
                                <textarea name="preferred_lesson_times" class="form-control" rows="3"><?= set_value('preferred_lesson_times') ?></textarea>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Learning Difficulties</label>
                                <textarea name="learning_difficulties" class="form-control" rows="3"><?= set_value('learning_difficulties') ?></textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary btn-block">Submit Registration</button>
                        </div>
                    <?= form_close() ?>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
// Optional: Additional client-side validation
(function() {
    'use strict';
    window.addEventListener('load', function() {
        var forms = document.getElementsByClassName('needs-validation');
        var validation = Array.prototype.filter.call(forms, function(form) {
            form.addEventListener('submit', function(event) {
                if (form.checkValidity() === false) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                form.classList.add('was-validated');
            }, false);
        });
    }, false);
})();
</script>